package com.vf106.tools.activity;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.alibaba.fastjson.JSONObject;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.uuzuche.lib_zxing.activity.CaptureActivity;
import com.vf106.tools.R;
import com.vf106.tools.activity.base.HttpBaseActivity;
import com.vf106.tools.bean.Device;
import com.vf106.tools.listener.OnHttpSuccessListener;
import com.vf106.tools.utils.Constants;
import com.vf106.tools.utils.DeviceUtil;
import com.vf106.tools.utils.Utils;
import com.vf106.tools.utils.wifi.WifiUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * @author syb
 * @date 2022/10/7 10:03
 */
public class DeviceInfoActivity extends HttpBaseActivity implements View.OnClickListener {

    private TextView etSystemVersion;
    private TextView etSnCode;
    private TextView etDeviceSpace;
    private TextView etDeviceActivate;
    private LinearLayout llRight;
    private LinearLayout llWrong;
    private int position;
    private int state;
    private String name;

    @Override
    protected void setContentView() {
        setContentView(R.layout.activity_device_info);
    }

    @Override
    protected void initViews() {
        Intent intent = getIntent();
        position = intent.getIntExtra("position", 0);
        name = intent.getStringExtra("name");
        state = intent.getIntExtra("state", 0);
        etSystemVersion = findViewById(R.id.et_system_version);
        etSnCode = findViewById(R.id.et_sn_code);
        etDeviceSpace = findViewById(R.id.et_device_space);
        etDeviceActivate = findViewById(R.id.et_device_activate);
        llRight = findViewById(R.id.ll_right);
        llWrong = findViewById(R.id.ll_wrong);
        TextView etSystemIp = findViewById(R.id.et_system_ip);
        etSystemIp.setText(Utils.getIPAddress(this));
    }

    @Override
    protected void setTitle() {
    }

    @Override
    protected void setListener() {
        llRight.setOnClickListener(this);
        llWrong.setOnClickListener(this);
    }

    @Override
    protected void initViewData() {
        String deviceSn = DeviceUtil.getDeviceId(this);
        etSnCode.setText(deviceSn);
        etSystemVersion.setText(Utils.getVersionName(this));
        etDeviceSpace.setText(Utils.getCache(this));
    }

    @Override
    protected void onResume() {
        super.onResume();
        getData();
    }

    public void getData() {
        final String url = Constants.FIND_BY_MEID + "?meId=" + DeviceUtil.getDeviceId(this);
        getData(Request.Method.GET, url, new Response.Listener<JSONObject>() {
            @Override
            public void onResponse(JSONObject response) {
                processResponse(response, url, null, "", new OnHttpSuccessListener() {
                    @Override
                    public void success(Object data) {
                        try {
                            org.json.JSONObject newDataObj = new org.json.JSONObject(data.toString());
                            if (!newDataObj.has("data")) {
                                return;
                            }

                            Device device = JSONObject.parseObject(newDataObj.getString("data"), Device.class);
                            if (device == null) {
                                etDeviceActivate.setText("inactive");
                                return;
                            }

                            //Activation status: 1 Activated 2 Expired 3 Replaced
                            Integer deviceState = device.getState();
                            if (deviceState == null || deviceState != 1) {
                                etDeviceActivate.setText("inactive");
                                return;
                            }

                            etDeviceActivate.setText("activated");
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
                hideLoadView();
            }
        }, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                hideLoadView();
                processError(error, url, "Failed to get!");
            }
        }, null);

    }

    /**
     * Jump to the code scanning interface to scan the code
     */
    public static final int REQUEST_CODE_SCAN = 100;

    public void goScan(View view) {
        Intent intent = new Intent(this, CaptureActivity.class);
        startActivityForResult(intent, REQUEST_CODE_SCAN);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == REQUEST_CODE_SCAN && resultCode == RESULT_OK) {
            if (data != null) {
                String content = data.getStringExtra("result_string");
                activate(content);
            }
        }
    }

    private void activate(String codeMsg) {
        showLoadView();
        Map<String, Object> params = new HashMap<>();
        params.put("meId", DeviceUtil.getDeviceId(this)); //Device Unique Identification
        params.put("version", DeviceUtil.getDeviceFlag() + "_" + Utils.getVersionName(getApplicationContext())); //Device version number
        params.put("macAddr", DeviceUtil.getMac(getApplicationContext())); //mac address
        params.put("protocolVersion", "V1.1.1"); //Request Interface Protocol Version
        params.put("activeType", 1); //Device activation type, 1: device activation, 2: device switching operations
        params.put("codeMsg", codeMsg);

        final String url = Constants.ACTIVATION;
        postData(Request.Method.POST, url, response -> {
            processResponse(response, url, null, "", data -> {
                org.json.JSONObject resultObj = new org.json.JSONObject(data.toString());
                if (!resultObj.has("data")) {
                    return;
                }

                org.json.JSONObject dataObj = resultObj.getJSONObject("data");
                String code = dataObj.getString("code");
                if (!"0000000".equals(code)) {
                    toast("Activation Failure");
                    return;
                }

                toast("Activation Success");
            });
            hideLoadView();
        }, error -> {
            hideLoadView();
            processError(error, url, "activation failure");
        }, params, null);
    }

    @SuppressLint("NonConstantResourceId")
    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.ll_right:
                state = 1;
                setIntentData();
                break;
            case R.id.ll_wrong:
                state = 2;
                setIntentData();
                break;
        }
    }

    public void setIntentData() {
        Intent intent = new Intent();
        intent.putExtra("name", name);
        intent.putExtra("state", state);
        intent.putExtra("position", position);
        setResult(Constants.resultCode, intent);
        finish();
    }
}
